﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Diagnostics;
using System.Drawing;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using tss;

/*
 www.liboke.cn
 */
namespace AppClass
{
    internal class App
    {

        Process p = null;
        StreamReader sr = null;
        TSPlugInterFace tss = new TSPlugInterFace();
        int picId, picW, picH, appW, appH;
        string appId;


        public App()
        {
            
        }




        /// <summary>
        /// 实际坐标计算
        /// </summary>
        /// <param name="n">pictureBox坐标</param>
        /// <returns>手机实际坐标</returns>
        private int intW(int n)
        {
            double nn = (double)appW / picW;
            return (int)(n * nn);
        }


        private int intH(int n)
        {
            double nn = (double)appH / picH;
            return (int)(n * nn);
        }





        //===================================================================





        /// <summary>
        /// 设置手机ID
        /// </summary>
        /// <param name="appId"></param>
        public void setAppId(string appId)
        {
            this.appId = appId;

            string appwh = huoquFenBianLu().Trim();
            string[] whs = appwh.Split('x');
            this.appW = int.Parse(whs[0]);
            this.appH = int.Parse(whs[1]);
        }

        /// <summary>
        /// 设置绑定pictureBox
        /// </summary>
        /// <param name="picId"></param>
        public void setPictureBox(PictureBox pic)
        {
            this.picId = (int)pic.Handle;
            this.picW = pic.Width;
            this.picH = pic.Height;
        }

        /// <summary>
        /// 获取手机宽度（分辨率）
        /// </summary>
        /// <returns></returns>
        public int getAppW() { return appW; }

        /// <summary>
        /// 获取手机高度（分辨率）
        /// </summary>
        /// <returns></returns>
        public int getAppH() { return appH; }











        /// <summary>
        /// ts.dll
        /// </summary>
        /// <returns></returns>
        public bool bdTS()
        {
            var ret = tss.BindWindow(picId, "gdi2", "normal", "normal", 1);
            tss.SetShowErrorMsg(0);
            return ret == 1 ? true : false;
        }


        public int[] tuXY(int x1, int y1, int x2, int y2, string imgpath)
        {
            object intX = 0;
            object intY = 0;
            var ret = tss.FindPic(x1, y1, x2, y2, imgpath, "000000",0.9, 0, out intX, out intY);
            int[] outn = new int[3];
            outn[0] = (int)intX>=0 || (int)intY>=0?1:0;
            outn[1] = (int)intX;
            outn[2] = (int)intY;
            return outn;
        }

        public int[] tuXY2(int x1, int y1, int x2, int y2, string imgpath,double xsd)
        {
            object intX = 0;
            object intY = 0;
            var ret = tss.FindPic(x1, y1, x2, y2, imgpath, "000000", xsd, 0, out intX, out intY);
            int[] outn = new int[3];
            outn[0] = (int)intX >= 0 || (int)intY >= 0 ? 1 : 0;
            outn[1] = (int)intX;
            outn[2] = (int)intY;
            return outn;
        }


        public int[] seXY(int x1, int y1, int x2, int y2, string se)
        {
            object intX = 0;
            object intY = 0;
            tss.FindColor(x1, y1, x2, y2, se + "-000000", 0.9, 0, out intX, out intY);
            int[] outn = new int[3];
            outn[0] = (int)intX >= 0 || (int)intY >= 0 ? 1 : 0;
            outn[1] = (int)intX;
            outn[2] = (int)intY;
            return outn;
        }
        


        /// <summary>
        /// 指定位置是否指定颜色
        /// </summary>
        /// <param name="x"></param>
        /// <param name="y"></param>
        /// <param name="se">颜色：ffffff</param>
        /// <returns></returns>
        public bool sfSE(int x, int y, string se) 
        {
            int n = tss.CmpColor(x, y, se + "-000000", 0.9);
            return (n == 0) ? true : false;
        }











        private static object cmd_obj = new object();  //线程保护
        /// <summary>
        /// 执行cmd命令
        /// </summary>
        /// <param name="ml"></param>
        public void cmd(string ml)
        {
            lock (cmd_obj)
            {
                try
                {
                    p = new Process();
                    p.StartInfo.FileName = "cmd.exe";
                    p.StartInfo.UseShellExecute = false;//是否使用操作系统shell启动
                    p.StartInfo.RedirectStandardInput = true; //重定向标准输入
                    p.StartInfo.RedirectStandardOutput = true;//重定向标准输出
                    p.StartInfo.RedirectStandardError = true;//重定向标准错误
                    p.StartInfo.CreateNoWindow = true;// 不显示窗口
                    p.StartInfo.WindowStyle = ProcessWindowStyle.Hidden;
                    p.Start();
                    p.StandardInput.WriteLine("cd " + Directory.GetCurrentDirectory() + "&&" + ml);
                    p.StandardInput.Flush();
                    Task.Delay(1000).Wait();
                    p.StandardInput.Close();//必须关闭输入流，否则是ReadToEnd会卡死
                    sr = p.StandardOutput;
                    while (!p.WaitForExit(1000)) ;
                    p.Close();
                    p.Dispose();
                }
                catch { }
                
            }
            
        }




        /// <summary>
        /// 关闭 cmd
        /// </summary>
        public void guanbiCmd()
        {
            if (p != null)
            {
                p.Close();
                p.Dispose();
                p = null;
            }
        }


        /// <summary>
        /// 关闭adb.exe
        /// </summary>
        public void guanbiAdb()
        {
            cmd("adb kill-server");
        }




        /// <summary>
        /// 获取已连接设备ID
        /// </summary>
        /// <returns></returns>
        public ArrayList huoquID()
        {
            cmd("adb devices");

            ArrayList arr = new ArrayList();

            while (!sr.EndOfStream)
            {
                string s = sr.ReadLine();
                string[] ss = s.Split('\t');
                if (ss.Length >= 2 && ss[1] == "device")
                {
                    arr.Add(ss[0]);
                }
            }
            return arr;
        }




        /// <summary>
        /// 设置分辨率
        /// </summary>
        private string huoquFenBianLu()
        {
            cmd("adb -s " + appId + " shell wm size");


            while (!sr.EndOfStream)
            {
                string s = sr.ReadLine();
                if (s.StartsWith("Physical size"))
                {
                    string[] ss = s.Split(':');
                    return ss[1];
                }
            }

            return string.Empty;
        }




        /// <summary>
        /// 获取app图
        /// </summary>
        public void huoquTU()
        {
            cmd("adb -s " + appId + " shell screencap -p /storage/emulated/0/apptu.bmp && " +
                "adb -s " + appId + " pull /storage/emulated/0/apptu.bmp adbimgs\\" + appId + ".bmp");
        }


        /// <summary>
        /// 打开app程序
        /// </summary>
        /// <param name="bm">包名</param>
        /// <param name="activity">Activity信息</param>
        public void dakaiAPP(string bm, string activity)
        {
            cmd("adb -s " + appId + " shell am start " + bm +"/"+activity);
        }


        /// <summary>
        /// 关闭app
        /// </summary>
        /// <param name="bm">包名</param>
        public void guanbiAPP(string bm)
        {
            cmd("adb -s " + appId + " shell am force-stop " + bm);
        }



        /// <summary>
        /// 点击
        /// </summary>
        /// <param name="x"></param>
        /// <param name="y"></param>
        public void DianJi(int x, int y)
        {
            Random random = new Random();
            int xx = x + random.Next(20);
            int yy = y + random.Next(20);
            cmd("adb -s " + appId + " shell input tap " + intW(xx) + " " + intH(yy));
        }


        /// <summary>
        /// 滑动
        /// </summary>
        /// <param name="x"></param>
        /// <param name="y"></param>
        public void SHua(int x1, int y1, int x2, int y2)
        {
            cmd("adb -s " + appId + " shell input swipe " + intW(x1) + " " + intH(y1) + " " + intW(x2) + " " + intH(y2) + " 200");
        }




        /// <summary>
        /// 左滑
        /// </summary>
        public void ZuoHua()
        {
            Random random = new Random();
            int xx1 = 260 + random.Next(20);
            int yy1 = 223 + random.Next(20);
            int xx2 = 136 + random.Next(20);
            int yy2 = 264 + random.Next(20);
            cmd("adb -s " + appId + " shell input swipe " + intW(xx1) + " " + intH(yy1) + " " + intW(xx2) + " " + intH(yy2) + " 200");
        }


        public void ZuoHua2()
        {
            Random random = new Random();
            int xx1 = 250 + random.Next(20);
            int yy1 = 20 + random.Next(20);
            int xx2 = 150 + random.Next(20);
            int yy2 = 20 + random.Next(20);
            cmd("adb -s " + appId + " shell input swipe " + intW(xx1) + " " + intH(yy1) + " " + intW(xx2) + " " + intH(yy2) + " 200");
        }


        /// <summary>
        /// 右滑
        /// </summary>
        public void YouHua()
        {
            Random random = new Random();
            int xx1 = 110 + random.Next(20);
            int yy1 = 283 + random.Next(20);
            int xx2 = 245 + random.Next(20);
            int yy2 = 239 + random.Next(20);
            cmd("adb -s " + appId + " shell input swipe " + intW(xx1) + " " + intH(yy1) + " " + intW(xx2) + " " + intH(yy2) + " 200");
        }




        /// <summary>
        /// 上滑
        /// </summary>
        public void ShangHua()
        {
            Random random = new Random();
            int xx1 = 151 + random.Next(20);
            int yy1 = 392 + random.Next(20);
            int xx2 = 170 + random.Next(20);
            int yy2 = 209 + random.Next(20);
            cmd("adb -s " + appId + " shell input swipe " + intW(xx1) + " " + intH(yy1) + " " + intW(xx2) + " " + intH(yy2) + " 200");
        }


        public void ShangHua2()
        {
            Random random = new Random();
            int xx1 = 166 + random.Next(20);
            int yy1 = 474 + random.Next(20);
            int xx2 = 149 + random.Next(20);
            int yy2 = 276 + random.Next(20);
            cmd("adb -s " + appId + " shell input swipe " + intW(xx1) + " " + intH(yy1) + " " + intW(xx2) + " " + intH(yy2) + " 800");
        }



        /// <summary>
        /// 下滑
        /// </summary>
        public void XiaHua()
        {
            Random random = new Random();
            int xx1 = 154 + random.Next(20);
            int yy1 = 204 + random.Next(20);
            int xx2 = 131 + random.Next(20);
            int yy2 = 390 + random.Next(20);
            cmd("adb -s " + appId + " shell input swipe " + intW(xx1) + " " + intH(yy1) + " " + intW(xx2) + " " + intH(yy2) + " 200");
        }

        public void XiaHua2()
        {
            Random random = new Random();
            int xx1 = 177 + random.Next(20);
            int yy1 = 238 + random.Next(20);
            int xx2 = 162 + random.Next(20);
            int yy2 = 370 + random.Next(20);
            cmd("adb -s " + appId + " shell input swipe " + intW(xx1) + " " + intH(yy1) + " " + intW(xx2) + " " + intH(yy2) + " 800");
        }


        /// <summary>
        /// 返回键
        /// </summary>
        public void FanHuiJian()
        {
            cmd("adb -s " +appId + " shell input keyevent 4");
        }


        public void FanHuiJian2()
        {
            cmd("adb -s " + appId + " shell input keyevent 4 && "+
                "adb -s " + appId + " shell input keyevent 4");
        }


        /// <summary>
        /// 返回键
        /// </summary>
        public void HomeJian()
        {
            cmd("adb -s " + appId + " shell input keyevent 3");
        }

    }
}
